<?php
	#################################################################
	##  WHMX Billing system for cPanel / WHM					   ##
	##-------------------------------------------------------------##
	##  Version: 1.00 - ENVATO MARKET                              ##
	##-------------------------------------------------------------##
	##  Author: Gianck Luiz obviosistemas@gmail.com         	   ##
	##-------------------------------------------------------------##
	##  Copyright ©2016 . All rights reserved.	                   ##
	##-------------------------------------------------------------##
	#################################################################

  function register_domain($domain,$api_key){
  $query_url = "https://www.above.com/registrar/api/query.html?key=" . urlencode($api_key) . "&query=register&domain=" . urlencode($domain);
  
  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);
  
    $results = simplexml_load_string($data); 
    
    $result_attr = $results->attributes();
    
    if($result_attr['code'] == 100) { // query was successful
    
      return  "<div class='alert alert-success'>" . htmlentities($domain) . " was registered successfully </div>";
        
    } else {     

      return "<div class='alert alert-danger'>" . htmlentities($domain) . " was NOT registered. Error message: " . $results->msg . "</div>";
  
    }
  
} // END


  function transfer_domain($domain,$api_key,$epp_code){
  
  $query_url = "https://www.above.com/registrar/api/query.html?key="
   . urlencode($api_key) . "&query=transfer&domain=" . urlencode($domain) . "&epp_code=" . urlencode($epp_code);

  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);

    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful

      return "<div class='alert alert-success'>" . htmlentities($domain) . " was successfully queued for transfer</div>";
        
    } else {     
    
      return "<div class='alert alert-danger'>" . htmlentities($domain) . " was NOT queued for transfer. Error code: " . $result_attr['code'] . " Error message: " . $results->msg . "</div>";
  
    }
    
  
} // END

  function request_epp($domain,$api_key){
		
  $query_url = "https://www.above.com/registrar/api/query.html?key="
   . urlencode($api_key) . "&query=request_epp&domain=" . urlencode($domain);

  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);

    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful

      return "<div class='alert alert-success'>" . htmlentities($domain) . " EPP Code: <b>" . $results->epp_code."</b></div>";
        
    } else {     
    
      return "<div class='alert alert-danger'>" . htmlentities($domain) . " not EPP Code. Error code: " . $result_attr['code'] . " Error message: " . $results->msg . "</div>";
  
    }
    
  
} // END

  function balance($api_key){
	
  $query_url = "https://www.above.com/registrar/api/query.html?key="   . urlencode($api_key) . "&query=balance";

  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);

    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful

      return "<div class='alert alert-info'>Balance Credit: " . $results->balance . " Above.com</div>";
        
    } else {     
    
      return "<div class='alert alert-danger'>" . $result_attr['code'] . " Error message: " . $results->msg . "</div>";
  
    }
    
    
	  
} // END


function privacy($domain,$api_key,$privacy){
	
  $query_url = "https://www.above.com/registrar/api/query.html?key="   . urlencode($api_key) . "&query=privacy&domain=".urlencode($domain)."&set_privacy=".urlencode($privacy)."";

  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);

    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful
	
	if($privacy == 'on') { 
		$retpr = "Active Privacy ";
	} else { 
		$retpr = "Cancel Privacy ";
	}
	
      return "Privacy uptade successfully: " . $retpr;
        
    } else {     
    
      return $result_attr['code'] . " Error message: " . $results->msg;
  
    }
    
   
	  
} // END


function renew($domain,$api_key,$renew_year){
	
  $query_url = "https://www.above.com/registrar/api/query.html?key="   . urlencode($api_key) . "&query=renew&domain=".urlencode($domain)."&renew_year=".urlencode($renew_year)."";
  
  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);


    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful
		
      return "<div class='alert alert-success'>Domain successfully renovated: " . $renew_year . " Years</div>";
        
    } else {     
    
      return "<div class='alert alert-danger'>" . $result_attr['code'] . " Error message: " . $results->msg . "</div>";
  
    }
    
  
	  
} // END


function update_dns($domain,$api_key,$dns1,$dns2){
	
  $query_url = "https://www.above.com/registrar/api/query.html?key="   . urlencode($api_key) . "&query=update_dns&domain=".urlencode($domain)."&dns=".urlencode($dns1).",".urlencode($dns2)."";

  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);


    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();

    if($result_attr['code'] == 100) { // query was successful
		
      return "<div class='alert alert-success'>DNS update successfully: " . htmlentities($domain) . "</div>";
        
    } else {     
    
      return "<div class='alert alert-danger'>" . $result_attr['code'] . " Error message: " . $results->msg . "</div>";
  
    }
    

	  
} // END


function pricing($api_key){
	
  $query_url = "https://www.above.com/registrar/api/query.html?key="   . urlencode($api_key) . "&query=pricing";
  
  $ch = curl_init($query_url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
  $data = curl_exec($ch);
  curl_close($ch);
  
  
    $results = simplexml_load_string($data); // you could also use a regex to get data, but this way is neater

    $result_attr = $results->attributes();
    

    if($result_attr['code'] == 100) { // query was successful
	
	
	foreach($results->children() as $books) { 
	echo "<tr>";
    echo "<td><b>" . $books['tld'] . "</b></td>"; 
    echo "<td>$" . $books->register . " USD</td>"; 
    echo "<td>$" . $books->renew . " USD</td>"; 
    echo "<td>$" . $books->transfer . " USD</td>"; 
    echo "<td>$" . $books->restore . " USD</td>"; 
	echo "</tr>";
    } 

    } else {     
    
      return $result_attr['code'] . " Error message: " . $results->msg;
  
    }
    
 
	  
} // END


